<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DumpPrivateKeyCommand extends AbstractCommand
{
    protected static $defaultName = 'dump-private-key';

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $factory = $this->createFactory($input);
        $output->writeln('<info>' . $factory->dumpPrivateKey() . '</info>');
        return 0;
    }
}
