<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator;

use HHIT\ConfigGenerator\Generator\Factory;

function cfgen_secrets_directory(string $projectDir, string $env)
{
    return $projectDir . '/config/secrets/' . $env;
}

function cfgen_private_key_path(string $projectDir, string $env)
{
    return cfgen_secrets_directory($projectDir, $env) . '/' . $env . '.decrypt.private.php';
}

function cfgen_decrypt_secret(string $projectDir, string $env, string $name)
{
    $privateKeyFile = cfgen_private_key_path($projectDir, $env);
    if (!file_exists($privateKeyFile)) {
        throw new \RuntimeException("Private key file $privateKeyFile does not exist!");
    }
    $factory = new Factory($projectDir, $env);
    $vault = $factory->createSodiumVault();

    $secret = $vault->reveal($name);
    if ($secret === null) {
        throw new \RuntimeException("Secret $name does not exist!");
    } else {
        return $secret;
    }
}
