<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Values;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\IO\JsonReader;
use HHIT\ConfigGenerator\Generator\Secrets\SecretProviderInterface;

class ValuesLoader extends JsonReader
{
    /**
     * @var array
     */
    private $context = [];
    /**
     * @var SecretProviderInterface
     */
    private $provider;
    /**
     * @var string
     */
    private $env;

    public function __construct(File $file, SecretProviderInterface $provider, string $env)
    {
        parent::__construct($file);
        $this->provider = $provider;
        $this->env = $env;
    }

    public function getValues()
    {
        if (!$this->context) {
            $this->context = $this->postProcess($this->readAsJson());
            if (array_key_exists('_env', $this->context)) {
                throw new \RuntimeException('_env is a reserved value - do not define it manually!');
            }
            $this->context['_env'] = $this->env;
        }
        return $this->context;
    }

    private function postProcess(array $array)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (array_key_exists('$type', $value) && array_key_exists('arg', $value)) {
                    $externalValueType = $value['$type'];
                    $externalValueArg = $value['arg'];
                    switch ($externalValueType) {
                        case 'secret':
                            $array[$key] = $this->provider->getSecret($externalValueArg);
                            break;
                        default:
                            throw new \RuntimeException("External value with type '{$externalValueType}' is not supported!");
                    }
                } else {
                    $array[$key] = $this->postProcess($value);
                }
            }
        }
        return $array;
    }
}
