<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Secrets;

use Symfony\Bundle\FrameworkBundle\Secrets\DotenvVault;
use Symfony\Bundle\FrameworkBundle\Secrets\SodiumVault;

class SymfonyVaultSecretProvider implements SecretProviderInterface
{
    /**
     * @var SodiumVault
     */
    private $sodiumVault;
    /**
     * @var DotenvVault
     */
    private $dotenvVault;

    public function __construct(SodiumVault $sodiumVault, DotenvVault $dotenvVault)
    {
        $this->sodiumVault = $sodiumVault;
        $this->dotenvVault = $dotenvVault;
    }

    public function getSecret(string $key): string
    {
        $secret = null;
        if (array_key_exists($key, $this->dotenvVault->list(false))) {
            $secret = $this->dotenvVault->reveal($key);
        }
        if ($secret) {
            return $secret;
        }
        $secret = $this->sodiumVault->reveal($key);
        if ($secret) {
            return $secret;
        } else {
            throw new \RuntimeException("Secret '{$key}' does not exist!");
        }
    }
}
