<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Definition;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\IO\Path;

class Definition
{
    /**
     * @var string
     */
    private $id;
    /**
     * @var File
     */
    private $templateFile;
    /**
     * @var string
     */
    private $type;
    /**
     * @var File
     */
    private $valuesFile;
    /**
     * @var File
     */
    private $destinationFile;

    public function __construct(string $id, File $templateFile, string $type, File $valuesFile, File $destinationFile)
    {
        $this->id = $id;
        $this->templateFile = $templateFile;
        $this->type = $type;
        $this->valuesFile = $valuesFile;
        $this->destinationFile = $destinationFile;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTemplateFile(): File
    {
        return $this->templateFile;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getValuesFile(): File
    {
        return $this->valuesFile;
    }

    public function getDestinationFile(): File
    {
        return $this->destinationFile;
    }
}
