<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\ConsoleOutputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class RemoveSecretsCommand extends AbstractCommand
{
    protected static $defaultName = 'remove-secrets';

    protected function configure()
    {
        parent::configure();
        $this->addArgument('name', InputArgument::REQUIRED, 'The name of the secret');
        $this->addOption('local', 'l', InputOption::VALUE_NONE, 'Updates the local vault.');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $factory = $this->createFactory($input);
        $vault = $factory->createSodiumVault();
        $localVault = $factory->createDotenvVault();

        $io = new SymfonyStyle($input, $output instanceof ConsoleOutputInterface ? $output->getErrorOutput() : $output);
        $vault = $input->getOption('local') ? $localVault : $vault;

        if (null === $vault) {
            $io->success('The local vault is disabled.');

            return 1;
        }

        if ($vault->remove($name = $input->getArgument('name'))) {
            $io->success($vault->getLastMessage() ?? 'Secret was removed from the vault.');
        } else {
            $io->comment($vault->getLastMessage() ?? 'Secret was not found in the vault.');
        }

        if ($vault === $vault && null !== $localVault->reveal($name)) {
            $io->comment('Note that this secret is overridden in the local vault.');
        }

        return 0;
    }
}
