<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Compiler;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\IO\FileReader;
use HHIT\ConfigGenerator\Generator\Values\ValuesLoader;
use LightnCandy\LightnCandy;

class Compiler extends FileReader
{
    /**
     * @var ValuesLoader
     */
    private $loader;
    /**
     * @var \Closure|null
     */
    private $fn = null;
    /**
     * @var \Closure[]
     */
    private $helpers = [];

    public function __construct(File $file, ValuesLoader $loader)
    {
        parent::__construct($file);
        $this->loader = $loader;

        $this->helpers = [
            'password_hash_default' => function ($password) {
                return password_hash($password, PASSWORD_DEFAULT);
            },
            'password_hash_bcrypt' => function ($password) {
                return password_hash($password, PASSWORD_BCRYPT);
            },
            'password_hash_argon2i' => function ($password) {
                if (!defined('PASSWORD_ARGON2I')) {
                    throw new \Exception('argon2i algorithm not supported!');
                }
                return password_hash($password, PASSWORD_ARGON2I);
            },
            'password_hash_argon2id' => function ($password) {
                if (!defined('PASSWORD_ARGON2ID')) {
                    throw new \Exception('argon2id algorithm not supported!');
                }
                return password_hash($password, PASSWORD_ARGON2ID);
            }
        ];
    }

    public function compile()
    {
        if (!$this->fn) {
            $compiled = LightnCandy::compile($this->read(), [
                'flags' => LightnCandy::FLAG_BESTPERFORMANCE | LightnCandy::FLAG_HANDLEBARS,
                'helpers' => $this->helpers
            ]);
            $this->fn = eval($compiled);
        }

        return $this->fn->call($this, $this->loader->getValues());
    }
}
