<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\IO;

class FileWriter
{
    /**
     * @var File
     */
    private $file;

    public function __construct(File $file)
    {
        $this->file = $file;
    }

    public function write($data, $overwrite = false)
    {
        if (!$overwrite) {
            if ($this->file->exists()) {
                throw new \RuntimeException("File '{$this->file->asString()}' exists but was not configured to be overwritten!");
            }
        }
        if (!$this->file->parent()->exists()) {
            $this->file->mkdir();
        }
        if (file_put_contents($this->file->asString(), $data) === false) {
            throw new \RuntimeException("Could not write to file '{$this->file->asString()}'!");
        }
    }
}
