<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Definition;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\IO\JsonReader;
use HHIT\ConfigGenerator\Generator\StringUtils;

class DefinitionReader
{
    private const RELATIVE_PATH_PREFIX = './';

    private string $projectDir;

    private string $env;

    public function __construct(string $projectDir, string $env)
    {
        $this->projectDir = $projectDir;
        $this->env = $env;
    }

    /**
     * @param string|null $definitionFileName
     * @return array<Definition>
     */
    public function read(?string $definitionFileName = null): array
    {
        $definitionFile = $definitionFileName ? new File($definitionFileName) : new File($this->projectDir . '/cfgen.json');
        $reader = new JsonReader($definitionFile);

        $definitions = [];

        foreach ($reader->readAsJson() as $id => $definition) {
            $templateFile = StringUtils::startsWith($definition['template'], self::RELATIVE_PATH_PREFIX) ?
                new File($definition['template'], $definitionFile) : new File($definition['template']);

            $valuesFile = StringUtils::startsWith($definition['values'], self::RELATIVE_PATH_PREFIX) ?
                new File($definition['values'], $definitionFile) : new File($definition['values']);

            $valuesEnvFileName = $this->valuesFileForEnv($definition['values'], $this->env);
            $valuesEnvFile = StringUtils::startsWith($valuesEnvFileName, self::RELATIVE_PATH_PREFIX) ?
                new File($valuesEnvFileName, $definitionFile) : new File($valuesEnvFileName);

            $destinationFile = StringUtils::startsWith($definition['destination'], self::RELATIVE_PATH_PREFIX) ?
                new File($definition['destination'], $definitionFile) : new File($definition['destination']);

            $definitions[] = new Definition($id, $templateFile, $definition['type'], $valuesFile, $valuesEnvFile, $destinationFile);
        }

        return $definitions;
    }

    private function valuesFileForEnv(string $valuesFile, string $env): ?string
    {
        $lastPos = strrpos($valuesFile, '.');
        if ($lastPos !== false) {
            $prefix = substr($valuesFile, 0, $lastPos);
            $suffix = substr($valuesFile, $lastPos);
            return "{$prefix}_{$env}{$suffix}";
        }

        return null;
    }
}
