<?php

declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Definition;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\IO\Path;

class Definition
{
    private string $id;
    private File $templateFile;
    private string $type;
    private File $valuesFile;
    private File $valuesEnvFile;
    private $destinationFile;

    public function __construct(string $id, File $templateFile, string $type, File $valuesFile, File $valuesEnvFile, File $destinationFile)
    {
        $this->id = $id;
        $this->templateFile = $templateFile;
        $this->type = $type;
        $this->valuesFile = $valuesFile;
        $this->valuesEnvFile = $valuesEnvFile;
        $this->destinationFile = $destinationFile;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTemplateFile(): File
    {
        return $this->templateFile;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getValuesFile(): File
    {
        return $this->valuesFile;
    }

    public function getValuesEnvFile(): ?File
    {
        if ($this->valuesEnvFile->exists()) {
            return $this->valuesEnvFile;
        } else {
            return null;
        }
    }

    public function getDestinationFile(): File
    {
        return $this->destinationFile;
    }
}
