<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Values;

use HHIT\ConfigGeneratorBundle\Generator\IO\File;
use HHIT\ConfigGeneratorBundle\Generator\IO\JsonReader;
use HHIT\ConfigGeneratorBundle\Generator\Secrets\SecretProviderInterface;

class ValuesLoader extends JsonReader
{
    private array $context = [];
    private SecretProviderInterface $provider;

    public function __construct(File $file, SecretProviderInterface $provider)
    {
        parent::__construct($file);
        $this->provider = $provider;
    }

    public function getValues()
    {
        if (!$this->context) {
            $this->context = $this->postProcess($this->readAsJson());
        }
        return $this->context;
    }

    private function postProcess(array $array)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (array_key_exists('$type', $value) && array_key_exists('arg', $value)) {
                    $externalValueType = $value['$type'];
                    $externalValueArg = $value['arg'];
                    switch ($externalValueType) {
                        case 'secret':
                            $array[$key] = $this->provider->getSecret($externalValueArg);
                            break;
                        default:
                            throw new \RuntimeException("External value with type '{$externalValueType}' is not supported!");
                    }
                } else {
                    $array[$key] = $this->postProcess($value);
                }
            }
        }

        return $array;
    }
}
