<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Validator;

class ValidatorFactory
{
    public function createValidator(string $type): ValidatorInterface
    {
        switch ($type) {
            case 'json':
                return new JSONValidator();
            case 'yaml':
                return new YamlValidator();
            default:
                throw new \RuntimeException("No validator exists for type '{$type}'!");
        }
    }
}
