<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Validator;

class JSONValidator implements ValidatorInterface
{
    public function validate(string $content)
    {
        try {
            json_decode($content, false, 512, JSON_THROW_ON_ERROR);
        } catch (\JsonException $e) {
            throw new ValidationException("JSON is invalid: {$e->getMessage()}", $e->getCode(), $e);
        }
    }
}
