<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Compiler;

use HHIT\ConfigGeneratorBundle\Generator\IO\File;
use HHIT\ConfigGeneratorBundle\Generator\IO\FileReader;
use HHIT\ConfigGeneratorBundle\Generator\Values\ValuesLoader;
use LightnCandy\LightnCandy;

class Compiler extends FileReader
{
    private ValuesLoader $loader;
    private ?\Closure $fn = null;
    private array $helpers = [];

    public function __construct(File $file, ValuesLoader $loader)
    {
        parent::__construct($file);
        $this->loader = $loader;

        $this->helpers = [
            'password_hash_default' => function ($password) {
                return password_hash($password, PASSWORD_DEFAULT);
            },
            'password_hash_bcrypt' => function ($password) {
                if (!in_array('2y', password_algos())) {
                    throw new \Exception('bcrypt algorithm not supported!');
                }
                return password_hash($password, PASSWORD_BCRYPT);
            },
            'password_hash_argon2i' => function ($password) {
                if (!in_array('argon2i', password_algos())) {
                    throw new \Exception('argon2i algorithm not supported!');
                }
                return password_hash($password, PASSWORD_ARGON2I);
            },
            'password_hash_argon2id' => function ($password) {
                if (!in_array('argon2id', password_algos())) {
                    throw new \Exception('argon2id algorithm not supported!');
                }
                return password_hash($password, PASSWORD_ARGON2ID);
            }
        ];
    }

    public function compile()
    {
        if (!$this->fn) {
            $compiled = LightnCandy::compile($this->read(), [
                'flags' => LightnCandy::FLAG_BESTPERFORMANCE | LightnCandy::FLAG_HANDLEBARS,
                'helpers' => $this->helpers
            ]);
            $this->fn = eval($compiled);
        }

        return $this->fn->call($this, $this->loader->getValues());
    }
}
