<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Command;

use HHIT\ConfigGeneratorBundle\Generator\Generator;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GenerateConfigsCommand extends Command
{
    protected static $defaultName = "cfgen:generate-configs";

    private Generator $generator;

    public function __construct(
        Generator $generator,
        string $name = null
    ) {
        parent::__construct($name);
        $this->generator = $generator;
    }

    protected function configure()
    {
        $this->addOption('config', 'c', InputOption::VALUE_OPTIONAL, 'configuration file (default is %kernel.project_dir%/cfgen.json)');
        $this->addOption('vault', null, InputOption::VALUE_REQUIRED, 'vault type', 'symfony');
        $this->addOption('overwrite', null, InputOption::VALUE_NONE, 'overwrite existing files');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $success = $this->generator->processConfigurations(
            $input->getOption('vault'),
            $input->getOption('overwrite') ? true : false,
            $input->getOption('config') ?: null,
            $output
        );

        return $success ? Command::SUCCESS : Command::FAILURE;
    }
}
