<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Secrets;

class SecretProviderFactory
{
    private SymfonyVaultSecretProvider $symfonyProvider;

    public function __construct(SymfonyVaultSecretProvider $symfonyProvider)
    {
        $this->symfonyProvider = $symfonyProvider;
    }

    public function create(string $type): SecretProviderInterface
    {
        switch ($type) {
            case 'symfony':
                return $this->symfonyProvider;
            default:
                throw new \RuntimeException("Secret provider with type '{$type}' is not supported!");
        }
    }
}
