<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Tests\Command;

use HHIT\ConfigGeneratorBundle\Command\GenerateConfigsCommand;
use HHIT\ConfigGeneratorBundle\Generator\Definition\DefinitionReader;
use HHIT\ConfigGeneratorBundle\Generator\IO\ReaderFactory;
use HHIT\ConfigGeneratorBundle\Generator\Generator;
use HHIT\ConfigGeneratorBundle\Generator\Secrets\SecretProviderFactory;
use HHIT\ConfigGeneratorBundle\Generator\Secrets\SymfonyVaultSecretProvider;
use HHIT\ConfigGeneratorBundle\Generator\Validator\ValidatorFactory;
use HHIT\ConfigGeneratorBundle\Generator\Values\ValuesLoaderFactory;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

class ConfigGeneratorBundleTest extends KernelTestCase
{

    /**
     * @before
     */
    public static function before()
    {
        self::bootKernel();
    }

    function dependencies()
    {
        return [
            'definition-reader' => [DefinitionReader::class],
            'symfony-vault-secret-provider' => [SymfonyVaultSecretProvider::class],
            'secret-provider-factory' => [SecretProviderFactory::class],
            'values-loader-factory' => [ValuesLoaderFactory::class],
            'validator-factory' => [ValidatorFactory::class],
            'processor' => [Generator::class],
            'generate-configs-command' => [GenerateConfigsCommand::class]
        ];
    }

    /**
     * @test
     * @dataProvider dependencies
     */
    function dependencyConfigured($id)
    {
        $this->assertNotNull(self::$container->get($id));
    }
}
