<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\IO;

use HHIT\ConfigGenerator\Generator\StringUtils;

abstract class Path
{
    /**
     * @var string
     */
    private $path;

    protected function __construct(string $path, ?File $relativeTo = null)
    {
        $this->path = $relativeTo ? $relativeTo->parent()->asString() . '/' . StringUtils::removeFromStart(trim($path), './') : trim($path);
    }

    public function asString(): string
    {
        return $this->path;
    }

    public function exists(): bool
    {
        clearstatcache();
        return file_exists($this->path);
    }

    public function parent(): Directory
    {
        return new Directory(dirname($this->path));
    }

    public function mkdir($mode = 0777)
    {
        $parent = $this->parent();
        if (mkdir($parent->asString(), $mode, true) === false) {
            throw new \RuntimeException("Could not create directory '{$parent->asString()}'!");
        }
    }
}
