<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Validator;

use Symfony\Component\Yaml\Exception\ParseException;
use Symfony\Component\Yaml\Yaml;

class YamlValidator implements ValidatorInterface
{
    public function validate(string $content)
    {
        try {
            Yaml::parse($content);
        } catch (ParseException $e) {
            throw new ValidationException("YAML is invalid: {$e->getMessage()}", $e->getCode(), $e);
        }
    }
}
