<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Definition;

use HHIT\ConfigGeneratorBundle\Generator\IO\File;
use HHIT\ConfigGeneratorBundle\Generator\IO\JsonReader;
use HHIT\ConfigGeneratorBundle\Generator\IO\Path;
use HHIT\ConfigGeneratorBundle\Generator\IO\ReaderFactory;
use HHIT\ConfigGeneratorBundle\Generator\StringUtils;

class DefinitionReader
{
    private string $projectDir;

    public function __construct(string $projectDir)
    {
        $this->projectDir = $projectDir;
    }

    /**
     * @param string|null $definitionFileName
     * @return array<Definition>
     */
    public function read(?string $definitionFileName = null): array
    {
        $definitionFile = $definitionFileName ? new File($definitionFileName) : new File($this->projectDir . '/cfgen.json');
        $reader = new JsonReader($definitionFile);

        $definitions = [];

        foreach ($reader->readAsJson() as $id => $definition) {
            $templateFile = StringUtils::startsWith($definition['template'], './') ?
                new File($definition['template'], $definitionFile) : new File($definition['template']);

            $valuesFile = StringUtils::startsWith($definition['values'], './') ?
                new File($definition['values'], $definitionFile) : new File($definition['values']);

            $destinationFile = StringUtils::startsWith($definition['destination'], './') ?
                new File($definition['destination'], $definitionFile) : new File($definition['destination']);

            $definitions[] = new Definition($id, $templateFile, $definition['type'], $valuesFile, $destinationFile);
        }

        return $definitions;
    }
}
