<?php
declare(strict_types=1);

namespace HHIT\ConfigGeneratorBundle\Generator\Definition;

use HHIT\ConfigGeneratorBundle\Generator\IO\File;
use HHIT\ConfigGeneratorBundle\Generator\IO\Path;

class Definition
{
    private string $id;
    private File $templateFile;
    private string $type;
    private File $valuesFile;
    private File $destinationFile;

    public function __construct(string $id, File $templateFile, string $type, File $valuesFile, File $destinationFile)
    {
        $this->id = $id;
        $this->templateFile = $templateFile;
        $this->type = $type;
        $this->valuesFile = $valuesFile;
        $this->destinationFile = $destinationFile;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTemplateFile(): File
    {
        return $this->templateFile;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getValuesFile(): File
    {
        return $this->valuesFile;
    }

    public function getDestinationFile(): File
    {
        return $this->destinationFile;
    }
}
