<?php

use HHIT\ConfigGenerator\Command\DumpPrivateKeyCommand;
use HHIT\ConfigGenerator\Command\GenerateConfigsCommand;
use HHIT\ConfigGenerator\Command\GenerateKeysCommand;
use HHIT\ConfigGenerator\Command\ListSecretsCommand;
use HHIT\ConfigGenerator\Command\SavePrivateKeyCommand;
use HHIT\ConfigGenerator\Command\SetSecretsCommand;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Input\ArgvInput;
use Symfony\Component\Console\Output\ConsoleOutput;

if (!in_array(PHP_SAPI, ['cli', 'phpdbg', 'embed'], true)) {
    echo 'Warning: The console should be invoked via the CLI version of PHP, not the '.PHP_SAPI.' SAPI'.PHP_EOL;
}

set_time_limit(0);

require_once __DIR__ . '/../vendor/autoload.php';
unset($candidates, $autoloaderPathCandidate, $pojectDirCandidate);

$application = new Application('Configuration Generator');
$application->add(new GenerateConfigsCommand(getcwd()));
$application->add(new ListSecretsCommand(getcwd()));
$application->add(new SetSecretsCommand(getcwd()));
$application->add(new GenerateKeysCommand(getcwd()));
$application->add(new DumpPrivateKeyCommand(getcwd()));
$application->add(new SavePrivateKeyCommand(getcwd()));

$input = new ArgvInput();
if (null !== $env = $input->getParameterOption(['--env', '-e'], 'dev', true)) {
    putenv('APP_ENV='.$_SERVER['APP_ENV'] = $_ENV['APP_ENV'] = $env);
}

$output = new ConsoleOutput();
$application->run($input, $output);
