<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\IO;

class JsonReader extends FileReader
{
    public function __construct(File $file)
    {
        parent::__construct($file);
    }

    public function readAsJson(bool $assoc = true, int $depth = 512)
    {
        $str = $this->read();
        if ($str) {
            $decoded = @json_decode($str, $assoc, $depth);
            $err = json_last_error();
            if ($err !== JSON_ERROR_NONE) {
                throw new \RuntimeException('Reading JSON failed: ' . json_last_error_msg(), $err);
            }
            return $decoded;
        }
    }
}
