<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use HHIT\ConfigGenerator\Generator\Factory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GenerateConfigsCommand extends Command
{
    protected static $defaultName = "generate-configs";

    private string $projectDir;

    public function __construct(string $projectDir, ?string $name = null)
    {
        $this->projectDir = $projectDir;
        parent::__construct($name);
    }

    protected function configure()
    {
        $this->addOption('project', 'p', InputOption::VALUE_OPTIONAL, 'project (dir)', $this->projectDir);
        $this->addOption('env', 'e', InputOption::VALUE_OPTIONAL, 'environment', 'dev');
        $this->addOption('config', 'c', InputOption::VALUE_OPTIONAL, 'configuration file');
        $this->addOption('overwrite', null, InputOption::VALUE_NONE, 'overwrite existing files');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $env = $input->getOption('env');

        $factory = new Factory($input->hasOption('project') ? $input->getOption('project') : $this->projectDir, $env);
        $factory->bootEnv();

        $generator = $factory->createGenerator();
        $output->writeln("<info>Generating configuration files for {$env}</info>");
        $success = $generator->processConfigurations(
            'symfony',
            $input->getOption('overwrite') ? true : false,
            $input->getOption('config') ?: null,
            $output
        );
        return $success ? 0 : 1;
    }
}
