<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Validator;

class JSONValidator implements ValidatorInterface
{
    public function validate(string $content)
    {
        @json_decode($content, false, 512);
        $err = json_last_error();
        if ($err !== JSON_ERROR_NONE) {
            throw new ValidationException("JSON is invalid: " . json_last_error_msg(), $err);
        }
    }
}
