<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use HHIT\ConfigGenerator\Generator\Factory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GenerateConfigsCommand extends AbstractCommand
{
    protected static $defaultName = "generate-configs";

    protected function configure()
    {
        parent::configure();
        $this->addOption('config', 'c', InputOption::VALUE_OPTIONAL, 'configuration file');
        $this->addOption('overwrite', null, InputOption::VALUE_NONE, 'overwrite existing files');
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $factory = $this->createFactory($input);
        $generator = $factory->createGenerator();
        $output->writeln("<info>Generating configuration files</info>");
        $success = $generator->processConfigurations(
            'symfony',
            $input->getOption('overwrite') ? true : false,
            $input->getOption('config') ?: null,
            $output
        );
        return $success ? 0 : 1;
    }
}
