<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use HHIT\ConfigGenerator\Generator\Factory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;

abstract class AbstractCommand extends Command
{
    /**
     * @var string
     */
    protected $projectDir;

    public function __construct(string $projectDir, ?string $name = null)
    {
        $this->projectDir = $projectDir;
        parent::__construct($name);
    }

    protected function configure()
    {
        $this->addOption('project', 'p', InputOption::VALUE_OPTIONAL, 'project (dir)', $this->projectDir);
        $this->addOption('env', 'e', InputOption::VALUE_OPTIONAL, 'environment', 'dev');
    }

    protected function createFactory(InputInterface $input): Factory
    {
        $env = $input->getOption('env');
        $factory = new Factory($input->hasOption('project') ? $input->getOption('project') : $this->projectDir, $env);
        $factory->bootEnv();
        return $factory;
    }
}
