<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\IO;

class FileReader
{
    private File $file;

    public function __construct(File $file)
    {
        $this->file = $file;
    }

    public function read()
    {
        if (!$this->file->exists()) {
            throw new \RuntimeException("File {$this->file->asString()} does not exist!");
        }
        return file_get_contents($this->file->asString());
    }
}
