<?php
if(!file_exists('build')) {
    mkdir('build');
}
if(file_exists('build/cfgen.phar')) {
    unlink('build/cfgen.phar');
}
$pharName = 'build/cfgen.phar';
$p = new Phar($pharName, FilesystemIterator::CURRENT_AS_FILEINFO | FilesystemIterator::KEY_AS_FILENAME, basename($pharName));
$p->startBuffering();
$p->setStub("#!/usr/bin/env php\n<?php Phar::mapPhar(); include \"phar://$pharName/src/cfgen.php\"; __HALT_COMPILER(); ?>");
$p->buildFromDirectory('.', '/(src|vendor)\/(.*)\.php$/', );
$p->stopBuffering();
chmod('build/cfgen.phar', 0755);
