<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Values;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\Secrets\SecretProviderFactory;

class ValuesLoaderFactory
{
    private SecretProviderFactory $secretProviderFactory;
    private string $env;

    public function __construct(SecretProviderFactory $secretProviderFactory, string $env)
    {
        $this->secretProviderFactory = $secretProviderFactory;
        $this->env = $env;
    }

    public function create(File $file, string $vaultType): ValuesLoader
    {
        return new ValuesLoader($file, $this->secretProviderFactory->create($vaultType), $this->env);
    }
}
