<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Command;

use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class SavePrivateKeyCommand extends AbstractCommand
{
    protected static $defaultName = 'save-private-key';

    protected function configure()
    {
        parent::configure();
        $this->addOption('key', 'k', InputOption::VALUE_REQUIRED, 'private key');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $factory = $this->createFactory($input);
        $key = $input->getOption('key');
        if (!$key) {
            throw new \RuntimeException('Key required!');
        }
        $factory->savePrivateKey($key);
        $output->writeln('<info>private key saved</info>');
        return 0;
    }
}
