<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\Values;

use HHIT\ConfigGenerator\Generator\IO\File;
use HHIT\ConfigGenerator\Generator\Secrets\SecretProviderFactory;

class ValuesLoaderFactory
{
    private SecretProviderFactory $secretProviderFactory;

    public function __construct(SecretProviderFactory $secretProviderFactory)
    {
        $this->secretProviderFactory = $secretProviderFactory;
    }

    public function create(File $file, string $vaultType): ValuesLoader
    {
        return new ValuesLoader($file, $this->secretProviderFactory->create($vaultType));
    }
}
