<?php
declare(strict_types=1);

namespace HHIT\ConfigGenerator\Generator\IO;

class JsonReader extends FileReader
{
    public function __construct(File $file)
    {
        parent::__construct($file);
    }

    public function readAsJson(bool $assoc = true, int $depth = 512)
    {
        $str = $this->read();
        if ($str) {
            try {
                return json_decode($str, $assoc, $depth, JSON_THROW_ON_ERROR);
            } catch (\JsonException $e) {
                throw new \RuntimeException('Reading JSON failed', 0, $e);
            }
        }
    }
}
